---
generated_at: 2026-01-21 10:30:00
metrics:
  claims_total: 16
  claims_with_evidence: 15
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：6-Set audio decoding mode.ps1.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：15 / 16、根拠なし：1
- 優先レビュー（高）
  1. **FLAC+qaacでPipeモードが必要な理由**：技術的背景の確認が必要
  2. **DecodingModeの選択肢**：他のモードとの違いの確認

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `Source/Scripts/Set audio decoding mode.ps1` 行1-17（スクリプト全体）
- E-02: `Source/Scripts/Set audio decoding mode.ps1` 行2（ErrorActionPreference設定）
- E-03: `Source/Scripts/Set audio decoding mode.ps1` 行4（Register-ObjectEvent）
- E-04: `Source/Scripts/Set audio decoding mode.ps1` 行5（アクティブプロジェクト取得）
- E-05: `Source/Scripts/Set audio decoding mode.ps1` 行7-15（条件判定・設定変更）
- E-06: `docs/code-to-docs/バッチ一覧/バッチ一覧.csv` 行7

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | BeforeProcessingイベントに登録する | E-03 | ○ |
| C-02 | ShortcutModule.gオブジェクトのイベントを使用 | E-03 | ○ |
| C-03 | ShortcutModule.pからアクティブプロジェクトを取得 | E-04 | ○ |
| C-04 | Audio0とAudio1をチェック | E-05 | ○ |
| C-05 | GetType().NameでGUIAudioProfile型をチェック | E-05 | ○ |
| C-06 | File.EndsWith('flac')で拡張子をチェック | E-05 | ○ |
| C-07 | GetEncoder()で'qaac'をチェック | E-05 | ○ |
| C-08 | 条件一致時にDecodingModeを'Pipe'に設定 | E-05 | ○ |
| C-09 | $ErrorActionPreference = 'Stop'を設定 | E-02 | ○ |
| C-10 | イベントハンドラとして登録される | E-03 | ○ |
| C-11 | エンコード処理開始前に実行される | E-03 | ○ |
| C-12 | ファイル出力がない | E-01 | ○ |
| C-13 | データベース操作がない | E-01 | ○ |
| C-14 | 条件不一致時は何も変更しない | E-05 | ○ |
| C-15 | ログ出力がない | E-01 | ○ |
| C-16 | FLAC+qaac使用時にPipeモードが必要な技術的理由 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- FLAC+qaac使用時にPipeモードが必要な技術的理由：スクリプトの処理内容からは、なぜこの組み合わせで特別な設定が必要かの技術的根拠を確認できません
  - 候補：StaxRipのドキュメント / qaacの仕様書 / FLACデコーダーの仕様 / StaxRip開発者への確認

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 設定変更のみで破壊的な操作はない
- 1: 中リスク - 条件判定が厳密でない場合、意図しない設定変更の可能性

## 6) レビュアーチェックリスト（最小）
- [ ] FLAC+qaac以外の組み合わせで問題が発生しないか確認
- [ ] DecodingMode='Pipe'がFLAC+qaacで適切な設定か確認
- [ ] Audio0、Audio1以外のオーディオトラックがある場合の動作確認
